# 矛盾论  
（一九三七年八月）  
  
> 这篇哲学论文，是毛泽东继《实践论》之后，为了同一的目的，即为了克服存在于中国共产党内的严重的教条主义思想而写的，曾在延安的抗日军事政治大学作过讲演。在收入本书第一版的时候，作者作了部分的补充、删节和修改。   
  
　　事物的矛盾法则，即对立统一的法则，是唯物辩证法的最根本的法则。列宁说：“就本来的意义讲，辩证法是研究对象的本质自身中的矛盾。”⑴列宁常称这个法则为辩证法的本质，又称之为辩证法的核心⑵。因此，我们在研究这个法则时，不得不涉及广泛的方面，不得不涉及许多的哲学问题。如果我们将这些问题都弄清楚了，我们就在根本上懂得了唯物辩证法。这些问题是：两种宇宙观；矛盾的普遍性；矛盾的特殊性；主要的矛盾和主要的矛盾方面；矛盾诸方面的同一性和斗争性；对抗在矛盾中的地位。   
　　苏联哲学界在最近数年中批判了德波林学派⑶的唯心论，这件事引起了我们的极大的兴趣。德波林的唯心论在中国共产党内发生了极坏的影响，我们党内的教条主义思想不能说和这个学派的作风没有关系。因此，我们现在的哲学研究工作，应当以扫除教条主义思想为主要的目标。   
  
## 一　两种宇宙观  

  
　　在人类的认识史中，从来就有关于宇宙发展法则的两种见解，一种是形而上学的见解，一种是辩证法的见解，形成了互相对立的两种宇宙观。列宁说：“对于发展（进化）所持的两种基本的（或两种可能的？或两种在历史上常见的？）观点是：（一）认为发展是减少和增加，是重复；（二）认为发展是对立的统一（统一物分成为两个互相排斥的对立，而两个对立又互相关联着）。”⑷列宁说的就是这两种不同的宇宙观。   
　　形而上学，亦称玄学。这种思想，无论在中国，在欧洲，在一个很长的历史时间内，是属于唯心论的宇宙观，并在人们的思想中占了统治的地位。在欧洲，资产阶级初期的唯物论，也是形而上学的。由于欧洲许多国家的社会经济情况进到了资本主义高度发展的阶段，生产力、阶级斗争和科学均发展到了历史上未有过的水平，工业无产阶级成为历史发展的最伟大的动力，因而产生了马克思主义的唯物辩证法的宇宙观。于是，在资产阶级那里，除了公开的极端露骨的反动的唯心论之外，还出现了庸俗的进化论，出来对抗唯物辩证法。   
　　所谓形而上学的或庸俗进化论的宇宙观，就是用孤立的、静止的和片面的观点去看世界。这种宇宙观把世界一切事物，一切事物的形态和种类，都看成是永远彼此孤立和永远不变化的。如果说有变化，也只是数量的增减和场所的变更。而这种增减和变更的原因，不在事物的内部而在事物的外部，即是由于外力的推动。形而上学家认为，世界上各种不同事物和事物的特性，从它们一开始存在的时候就是如此。后来的变化，不过是数量上的扩大或缩小。他们认为一种事物永远只能反复地产生为同样的事物，而不能变化为另一种不同的事物。在形而上学家看来，资本主义的剥削，资本主义的竞争，资本主义社会的个人主义思想等，就是在古代的奴隶社会里，甚至在原始社会里，都可以找得出来，而且会要永远不变地存在下去。说到社会发展的原因，他们就用社会外部的地理、气候等条件去说明。他们简单地从事物外部去找发展的原因，否认唯物辩证法所主张的事物因内部矛盾引起发展的学说。因此，他们不能解释事物的质的多样性，不能解释一种质变为他种质的现象。这种思想，在欧洲，在十七世纪和十八世纪是机械唯物论，在十九世纪末和二十世纪初则有庸俗进化论。在中国，则有所谓“天不变，道亦不变”⑸的形而上学的思想，曾经长期地为腐朽了的封建统治阶级所拥护。近百年来输入了欧洲的机械唯物论和庸俗进化论，则为资产阶级所拥护。   
　　和形而上学的宇宙观相反，唯物辩证法的宇宙观主张从事物的内部、从一事物对他事物的关系去研究事物的发展，即把事物的发展看做是事物内部的必然的自己的运动，而每一事物的运动都和它的周围其他事物互相联系着和互相影响着。事物发展的根本原因，不是在事物的外部而是在事物的内部，在于事物内部的矛盾性。任何事物内部都有这种矛盾性，因此引起了事物的运动和发展。事物内部的这种矛盾性是事物发展的根本原因，一事物和他事物的互相联系和互相影响则是事物发展的第二位的原因。这样，唯物辩证法就有力地反对了形而上学的机械唯物论和庸俗进化论的外因论或被动论。这是清楚的，单纯的外部原因只能引起事物的机械的运动，即范围的大小，数量的增减，不能说明事物何以有性质上的千差万别及其互相变化。事实上，即使是外力推动的机械运动，也要通过事物内部的矛盾性。植物和动物的单纯的增长，数量的发展，主要地也是由于内部矛盾所引起的。同样，社会的发展，主要地不是由于外因而是由于内因。许多国家在差不多一样的地理和气候的条件下，它们发展的差异性和不平衡性，非常之大。同一个国家吧，在地理和气候并没有变化的情形下，社会的变化却是很大的。帝国主义的俄国变为社会主义的苏联，封建的闭关锁国的日本变为帝国主义的日本，这些国家的地理和气候并没有变化。长期地被封建制度统治的中国，近百年来发生了很大的变化，现在正在变化到一个自由解放的新中国的方向去，中国的地理和气候并没有变化。整个地球及地球各部分的地理和气候也是变化着的，但以它们的变化和社会的变化相比较，则显得很微小，前者是以若干万年为单位而显现其变化的，后者则在几千年、几百年、几十年、甚至几年或几个月（在革命时期）内就显现其变化了。按照唯物辩证法的观点，自然界的变化，主要地是由于自然界内部矛盾的发展。社会的变化，主要地是由于社会内部矛盾的发展，即生产力和生产关系的矛盾，阶级之间的矛盾，新旧之间的矛盾，由于这些矛盾的发展，推动了社会的前进，推动了新旧社会的代谢。唯物辩证法是否排除外部的原因呢？并不排除。唯物辩证法认为外因是变化的条件，内因是变化的根据，外因通过内因而起作用。鸡蛋因得适当的温度而变化为鸡子，但温度不能使石头变为鸡子，因为二者的根据是不同的。各国人民之间的互相影响是时常存在的。在资本主义时代，特别是在帝国主义和无产阶级革命的时代，各国在政治上、经济上和文化上的互相影响和互相激动，是极其巨大的。十月社会主义革命不只是开创了俄国历史的新纪元，而且开创了世界历史的新纪元，影响到世界各国内部的变化，同样地而且还特别深刻地影响到中国内部的变化，但是这种变化是通过了各国内部和中国内部自己的规律性而起的。两军相争，一胜一败，所以胜败，皆决于内因。胜者或因其强，或因其指挥无误，败者或因其弱，或因其指挥失宜，外因通过内因而引起作用。一九二七年中国大资产阶级战败了无产阶级，是通过中国无产阶级内部的（中国共产党内部的）机会主义而起作用的。当着我们清算了这种机会主义的时候，中国革命就重新发展了。后来，中国革命又受了敌人的严重的打击，是因为我们党内产生了冒险主义。当着我们清算了这种冒险主义的时候，我们的事业就又重新发展了。由此看来，一个政党要引导革命到胜利，必须依靠自己政治路线的正确和组织上的巩固。   
　　辩证法的宇宙观，不论在中国，在欧洲，在古代就产生了。但是古代的辩证法带着自发的朴素的性质，根据当时的社会历史条件，还不可能有完备的理论，因而不能完全解释宇宙，后来就被形而上学所代替。生活在十八世纪末和十九世纪初期的德国著名哲学家黑格尔，对于辩证法曾经给了很重要的贡献，但是他的辩证法却是唯心的辩证法。直到无产阶级运动的伟大的活动家马克思和恩格斯综合了人类认识史的积极的成果，特别是批判地吸取了黑格尔的辩证法的合理的部分，创造了辩证唯物论和历史唯物论这个伟大的理论，才在人类认识史上起了一个空前的大革命。后来，经过列宁和斯大林，又发展了这个伟大的理论。这个理论一经传到中国来，就在中国思想界引起了极大的变化。   
　　这个辩证法的宇宙观，主要地就是教导人们要善于去观察和分析各种事物的矛盾的运动，并根据这种分析，指出解决矛盾的方法。因此，具体地了解事物矛盾这一个法则，对于我们是非常重要的。   
## 二　矛盾的普遍性  

  
　　为了叙述的便利起见，我在这里先说矛盾的普遍性，再说矛盾的特殊性。这是因为马克思主义的伟大的创造者和继承者马克思、恩格斯、列宁、斯大林他们发现了唯物辩证法的宇宙观，已经把唯物辩证法应用在人类历史的分析和自然历史的分析的许多方面，应用在社会的变革和自然的变革（例如在苏联）的许多方面，获得了极其伟大的成功，矛盾的普遍性已经被很多人所承认，因此，关于这个问题只需要很少的话就可以说明白；而关于矛盾的特殊性的问题，则还有很多的同志，特别是教条主义者，弄不清楚。他们不了解矛盾的普遍性即寓于矛盾的特殊性之中。他们也不了解研究当前具体事物的矛盾的特殊性，对于我们指导革命实践的发展有何等重要的意义。因此，关于矛盾的特殊性的问题应当着重地加以研究，并用足够的篇幅加以说明。为了这个缘故，当着我们分析事物矛盾的法则的时候，我们就先来分析矛盾的普遍性的问题，然后再着重地分析矛盾的特殊性的问题，最后仍归到矛盾的普遍性的问题。   
　　矛盾的普遍性或绝对性这个问题有两方面的意义。其一是说，矛盾存在于一切事物的发展过程中；其二是说，每一事物的发展过程中存在着自始至终的矛盾运动。   
　　恩格斯说：“运动本身就是矛盾。”⑹列宁对于对立统一法则所下的定义，说它就是“承认（发现）自然界（精神和社会两者也在内）的一切现象和过程都含有互相矛盾、互相排斥、互相对立的趋向”⑺。这些意见是对的吗？是对的。一切事物中包含的矛盾方面的相互依赖和相互斗争，决定一切事物的生命，推动一切事物的发展。没有什么事物是不包含矛盾的，没有矛盾就没有世界。   
　　矛盾是简单的运动形式（例如机械性的运动）的基础，更是复杂的运动形式的基础。   
　　恩格斯这样说明过矛盾的普遍性：“如果简单的机械的移动本身包含着矛盾，那末，物质的更高的运动形式，特别是有机生命及其发展，就更加包含着矛盾。……生命首先就在于：生物在每一个瞬间是它自身，但却又是别的什么。所以，生命也是存在于物体和过程本身中的不断地自行产生并自行解决的矛盾；这一矛盾一停止，生命亦即停止，于是死就来到。同样，我们看到了，在思维的范围以内我们也不能避免矛盾，并且我们看到了，例如，人的内部无限的认识能力与此种认识能力仅在外部被局限的而且认识上也被局限的个别人们身上的实际的实现二者之间的矛盾，是在人类世代的无穷的——至少对于我们，实际上是无穷的——连续系列之中，是在无穷的前进运动之中解决的。”   
　　“高等数学的主要基础之一，就是矛盾……”   
　　“就是初等数学，也充满着矛盾。……”⑻   
　　列宁也这样说明过矛盾的普遍性：“在数学中，正和负，微分和积分。   
　　在力学中，作用和反作用。   
　　在物理学中，阳电和阴电。   
　　在化学中，原子的化合和分解。   
　　在社会科学中，阶级斗争。”⑼   
　　战争中的攻守，进退，胜败，都是矛盾着的现象。失去一方，他方就不存在。双方斗争而又联结，组成了战争的总体，推动了战争的发展，解决了战争的问题。   
　　人的概念的每一差异，都应把它看作是客观矛盾的反映。客观矛盾反映入主观的思想，组成了概念的矛盾运动，推动了思想的发展，不断地解决了人们的思想问题。   
　　党内不同思想的对立和斗争是经常发生的，这是社会的阶级矛盾和新旧事物的矛盾在党内的反映。党内如果没有矛盾和解决矛盾的思想斗争，党的生命也就停止了。   
　　由此看来，不论是简单的运动形式，或复杂的运动形式，不论是客观现象，或思想现象，矛盾是普遍地存在着，矛盾存在于一切过程中，这一点已经弄清楚了。但是每一过程的开始阶段，是否也有矛盾存在呢？是否每一事物的发展过程具有自始至终的矛盾运动呢？   
　　从苏联哲学界批判德波林学派的文章中看出，德波林学派有这样一种见解，他们认为矛盾不是一开始就在过程中出现，须待过程发展到一定的阶段才出现。那末，在那一时间以前，过程发展的原因不是由于内部的原因，而是由于外部的原因了。这样，德波林回到形而上学的外因论和机械论去了。拿这种见解去分析具体的问题，他们就看见在苏联条件下富农和一般农民之间只有差异，并无矛盾，完全同意了布哈林的意见。在分析法国革命时，他们就认为在革命前，工农资产阶级合组的第三等级中，也只有差异，并无矛盾。德波林学派这类见解是反马克思主义的。他们不知道世界上的每一差异中就已经包含着矛盾，差异就是矛盾。劳资之间，从两阶级发生的时候起，就是互相矛盾的，仅仅还没有激化而已。工农之间，即使在苏联的社会条件下，也有差异，它们的差异就是矛盾，仅仅不会激化成为对抗，不取阶级斗争的形态，不同于劳资间的矛盾；它们在社会主义建设中形成巩固的联盟，并在由社会主义走向共产主义的发展过程中逐渐地解决这个矛盾。这是矛盾的差别性的问题，不是矛盾的有无的问题。矛盾是普遍的、绝对的，存在于事物发展的一切过程中，又贯串于一切过程的始终。   
　　新过程的发生是什么呢？这是旧的统一和组成此统一的对立成分让位于新的统一和组成此统一的对立成分，于是新过程就代替旧过程而发生。旧过程完结了，新过程发生了。新过程又包含着新矛盾，开始它自己的矛盾发展史。   
　　事物发展过程的自始至终的矛盾运动，列宁指出马克思在《资本论》中模范地作了这样的分析。这是研究任何事物发展过程所必须应用的方法。列宁自己也正确地应用了它，贯彻于他的全部著作中。   
　　“马克思在《资本论》中，首先分析的是资产阶级社会（商品社会）里最简单的、最普通的、最基本的、最常见的、最平常的、碰到亿万次的关系——商品交换。这一分析在这个最简单的现象之中（资产阶级社会的这个‘细胞’之中）暴露了现代社会的一切矛盾（以及一切矛盾的胚芽）。往后的叙述又向我们表明了这些矛盾和这个社会各个部分总和的自始至终的发展（增长与运动两者）。”   
　　列宁说了上面的话之后，接着说道：“这应该是一般辩证法的……叙述（以及研究）方法。”⑽   
　　中国共产党人必须学会这个方法，才能正确地分析中国革命的历史和现状，并推断革命的将来。   
## 三　矛盾的特殊性  

  
　　矛盾存在于一切事物发展的过程中，矛盾贯串于每一事物发展过程的始终，这是矛盾的普遍性和绝对性，前面已经说过了。现在来说矛盾的特殊性和相对性。   
　　这个问题，应从几种情形中去研究。   
　　首先是各种物质运动形式中的矛盾，都带特殊性。人的认识物质，就是认识物质的运动形式，因为除了运动的物质以外，世界上什么也没有，而物质的运动则必取一定的形式。对于物质的每一种运动形式，必须注意它和其他各种运动形式的共同点。但是，尤其重要的，成为我们认识事物的基础的东西，则是必须注意它的特殊点，就是说，注意它和其他运动形式的质的区别。只有注意了这一点，才有可能区别事物。任何运动形式，其内部都包含着本身特殊的矛盾。这种特殊的矛盾，就构成一事物区别于他事物的特殊的本质。这就是世界上诸种事物所以有千差万别的内在的原因，或者叫做根据。自然界存在着许多的运动形式，机械运动、发声、发光、发热、电流、化分、化合等等都是。所有这些物质的运动形式，都是互相依存的，又是本质上互相区别的。每一物质的运动形式所具有的特殊的本质，为它自己的特殊的矛盾所规定。这种情形，不但在自然界中存在着，在社会现象和思想现象中也是同样地存在着。每一种社会形式和思想形式，都有它的特殊的矛盾和特殊的本质。   
　　科学研究的区分，就是根据科学对象所具有的特殊的矛盾性。因此，对于某一现象的领域所特有的某一种矛盾的研究，就构成某一门科学的对象。例如，数学中的正数和负数，机械学中的作用和反作用，物理学中的阴电和阳电，化学中的化分和化合，社会科学中的生产力和生产关系、阶级和阶级的互相斗争，军事学中的攻击和防御，哲学中的唯心论和唯物论、形而上学观和辩证法观等等，都是因为具有特殊的矛盾和特殊的本质，才构成了不同的科学研究的对象。固然，如果不认识矛盾的普遍性，就无从发现事物运动发展的普遍的原因或普遍的根据；但是，如果不研究矛盾的特殊性，就无从确定一事物不同于他事物的特殊的本质，就无从发现事物运动发展的特殊的原因，或特殊的根据，也就无从辨别事物，无从区分科学研究的领域。   
　　就人类认识运动的秩序说来，总是由认识个别的和特殊的事物，逐步地扩大到认识一般的事物。人们总是首先认识了许多不同事物的特殊的本质，然后才有可能更进一步地进行概括工作，认识诸种事物的共同的本质。当着人们已经认识了这种共同的本质以后，就以这种共同的认识为指导，继续地向着尚未研究过的或者尚未深入地研究过的各种具体的事物进行研究，找出其特殊的本质，这样才可以补充、丰富和发展这种共同的本质的认识，而使这种共同的本质的认识不致变成枯槁的和僵死的东西。这是两个认识的过程：一个是由特殊到一般，一个是由一般到特殊。人类的认识总是这样循环往复地进行的，而每一次的循环（只要是严格地按照科学的方法）都可能使人类的认识提高一步，使人类的认识不断地深化。我们的教条主义者在这个问题上的错误，就是，一方面，不懂得必须研究矛盾的特殊性，认识各别事物的特殊的本质，才有可能充分地认识矛盾的普遍性，充分地认识诸种事物的共同的本质；另一方面，不懂得在我们认识了事物的共同的本质以后，还必须继续研究那些尚未深入地研究过的或者新冒出来的具体的事物。我们的教条主义者是懒汉，他们拒绝对于具体事物做任何艰苦的研究工作，他们把一般真理看成是凭空出现的东西，把它变成为人们所不能够捉摸的纯粹抽象的公式，完全否认了并且颠倒了这个人类认识真理的正常秩序。他们也不懂得人类认识的两个过程的互相联结——由特殊到一般，又由一般到特殊，他们完全不懂得马克思主义的认识论。   
　　不但要研究每一个大系统的物质运动形式的特殊的矛盾性及其所规定的本质，而且要研究每一个物质运动形式在其发展长途中的每一个过程的特殊的矛盾及其本质。一切运动形式的每一个实在的非臆造的发展过程内，都是不同质的。我们的研究工作必须着重这一点，而且必须从这一点开始。   
　　不同质的矛盾，只有用不同质的方法才能解决。例如，无产阶级和资产阶级的矛盾，用社会主义革命的方法去解决；人民大众和封建制度的矛盾，用民主革命的方法去解决；殖民地和帝国主义的矛盾，用民族革命战争的方法去解决；在社会主义社会中工人阶级和农民阶级的矛盾，用农业集体化和农业机械化的方法去解决；共产党内的矛盾，用批评和自我批评的方法去解决；社会和自然的矛盾，用发展生产力的方法去解决。过程变化，旧过程和旧矛盾消灭，新过程和新矛盾发生，解决矛盾的方法也因之而不同。俄国的二月革命和十月革命所解决的矛盾及其所用以解决矛盾的方法是根本上不相同的。用不同的方法去解决不同的矛盾，这是马克思列宁主义者必须严格地遵守的一个原则。教条主义者不遵守这个原则，他们不了解诸种革命情况的区别，因而也不了解应当用不同的方法去解决不同的矛盾，而只是千篇一律地使用一种自以为不可改变的公式到处硬套，这就只能使革命遭受挫折，或者将本来做得好的事情弄得很坏。   
　　为要暴露事物发展过程中的矛盾在其总体上、在其相互联结上的特殊性，就是说暴露事物发展过程的本质，就必须暴露过程中矛盾各方面的特殊性，否则暴露过程的本质成为不可能，这也是我们作研究工作时必须十分注意的。   
　　一个大的事物，在其发展过程中，包含着许多的矛盾。例如，在中国资产阶级民主革命过程中，有中国社会各被压迫阶级和帝国主义的矛盾，有人民大众和封建制度的矛盾，有无产阶级和资产阶级的矛盾，有农民及城市小资产阶级和资产阶级的矛盾，有各个反动的统治集团之间的矛盾等等，情形是非常复杂的。这些矛盾，不但各各有其特殊性，不能一律看待，而且每一矛盾的两方面，又各各有其特点，也是不能一律看待的。我们从事中国革命的人，不但要在各个矛盾的总体上，即矛盾的相互联结上，了解其特殊性，而且只有从矛盾的各个方面着手研究，才有可能了解其总体。所谓了解矛盾的各个方面，就是了解它们每一方面各占何等特定的地位，各用何种具体形式和对方发生互相依存又互相矛盾的关系，在互相依存又互相矛盾中，以及依存破裂后，又各用何种具体的方法和对方作斗争。研究这些问题，是十分重要的事情。列宁说：马克思主义的最本质的东西，马克思主义的活的灵魂，就在于具体地分析具体的情况⑾。就是说的这个意思。我们的教条主义者违背列宁的指示，从来不用脑筋具体地分析任何事物，做起文章或演说来，总是空洞无物的八股调，在我们党内造成了一种极坏的作风。   
　　研究问题，忌带主观性、片面性和表面性。所谓主观性，就是不知道客观地看问题，也就是不知道用唯物的观点去看问题。这一点，我在《实践论》一文中已经说过了。所谓片面性，就是不知道全面地看问题。例如：只了解中国一方、不了解日本一方，只了解共产党一方、不了解国民党一方，只了解无产阶级一方、不了解资产阶级一方，只了解农民一方、不了解地主一方，只了解顺利情形一方、不了解困难情形一方，只了解过去一方、不了解将来一方，只了解个体一方、不了解总体一方，只了解缺点一方、不了解成绩一方，只了解原告一方、不了解被告一方，只了解革命的秘密工作一方、不了解革命的公开工作一方，如此等等。一句话，不了解矛盾各方的特点。这就叫做片面地看问题。或者叫做只看见局部，不看见全体，只看见树木，不看见森林。这样，是不能找出解决矛盾的方法的，是不能完成革命任务的，是不能做好所任工作的，是不能正确地发展党内的思想斗争的。孙子论军事说：“知彼知己，百战不殆。”⑿他说的是作战的双方。唐朝人魏徵说过：“兼听则明，偏信则暗。”⒀也懂得片面性不对。可是我们的同志看问题，往往带片面性，这样的人就往往碰钉子。《水浒传》上宋江三打祝家庄⒁，两次都因情况不明，方法不对，打了败仗。后来改变方法，从调查情形入手，于是熟悉了盘陀路，拆散了李家庄、扈家庄和祝家庄的联盟，并且布置了藏在敌人营盘里的伏兵，用了和外国故事中所说木马计⒂相像的方法，第三次就打了胜仗。《水浒传》上有很多唯物辩证法的事例，这个三打祝家庄，算是最好的一个。列宁说：“要真正地认识对象，就必须把握和研究它的一切方面、一切联系和‘媒介’。我们决不会完全地作到这一点，可是要求全面性，将使我们防止错误，防止僵化。”⒃我们应该记得他的话。表面性，是对矛盾总体和矛盾各方的特点都不去看，否认深入事物里面精细地研究矛盾特点的必要，仅仅站在那里远远地望一望，粗枝大叶地看到一点矛盾的形相，就想动手去解决矛盾（答复问题、解决纠纷、处理工作、指挥战争）。这样的做法，没有不出乱子的。中国的教条主义和经验主义的同志们所以犯错误，就是因为他们看事物的方法是主观的、片面的和表面的。片面性、表面性也是主观性，因为一切客观事物本来是互相联系的和具有内部规律的，人们不去如实地反映这些情况，而只是片面地或表面地去看它们，不认识事物的互相联系，不认识事物的内部规律，所以这种方法是主观主义的。   
　　不但事物发展的全过程中的矛盾运动，在其相互联结上，在其各方情况上，我们必须注意其特点，而且在过程发展的各个阶段中，也有其特点，也必须注意。   
　　事物发展过程的根本矛盾及为此根本矛盾所规定的过程的本质，非到过程完结之日，是不会消灭的；但是事物发展的长过程中的各个发展的阶段，情形又往往互相区别。这是因为事物发展过程的根本矛盾的性质和过程的本质虽然没有变化，但是根本矛盾在长过程中的各个发展阶段上采取了逐渐激化的形式。并且，被根本矛盾所规定或影响的许多大小矛盾中，有些是激化了，有些是暂时地或局部地解决了，或者缓和了，又有些是发生了，因此，过程就显出阶段性来。如果人们不去注意事物发展过程中的阶段性，人们就不能适当地处理事物的矛盾。   
　　例如，自由竞争时代的资本主义发展为帝国主义，这时，无产阶级和资产阶级这两个根本矛盾着的阶级的性质和这个社会的资本主义的本质，并没有变化；但是，两阶级的矛盾激化了，独占资本和自由资本之间的矛盾发生了，宗主国和殖民地的矛盾激化了，各资本主义国家间的矛盾即由各国发展不平衡的状态而引起的矛盾特别尖锐地表现出来了，因此形成了资本主义的特殊阶段，形成了帝国主义阶段。列宁主义之所以成为帝国主义和无产阶级革命时代的马克思主义，就是因为列宁和斯大林正确地说明了这些矛盾，并正确地作出了解决这些矛盾的无产阶级革命的理论和策略。   
　　拿从辛亥革命⒄开始的中国资产阶级民主革命过程的情形来看，也有了若干特殊阶段。特别是在资产阶级领导时期的革命和在无产阶级领导时期的革命，区别为两个很大不同的历史阶段。这就是：由于无产阶级的领导，根本地改变了革命的面貌，引出了阶级关系的新调度，农民革命的大发动，反帝国主义和反封建主义的革命彻底性，由民主革命转变到社会主义革命的可能性，等等。所有这些，都是在资产阶级领导革命时期不可能出现的。虽然整个过程中根本矛盾的性质，过程之反帝反封建的民主革命的性质（其反面是半殖民地半封建的性质），并没有变化，但是，在这长时间中，经过了辛亥革命失败和北洋军阀统治，第一次民族统一战线的建立和一九二四年至一九二七年的革命，统一战线破裂和资产阶级转入反革命，新的军阀战争，土地革命战争，第二次民族统一战线建立和抗日战争等等大事变，二十多年间经过了几个发展阶段。在这些阶段中，包含着有些矛盾激化了（例如土地革命战争和日本侵入东北四省⒅），有些矛盾部分地或暂时地解决了（例如北洋军阀的被消灭，我们没收了地主的土地），有些矛盾重新发生了（例如新军阀之间的斗争，南方各革命根据地丧失后地主又重新收回土地）等等特殊的情形。   
　　研究事物发展过程中的各个发展阶段上的矛盾的特殊性，不但必须在其联结上、在其总体上去看，而且必须从各个阶段中矛盾的各个方面去看。   
　　例如国共两党。国民党方面，在第一次统一战线时期，因为它实行了孙中山的联俄、联共、援助工农的三大政策，所以它是革命的、有朝气的，它是各阶级的民主革命的联盟。一九二七年以后，国民党变到了与此相反的方面，成了地主和大资产阶级的反动集团。一九三六年十二月西安事变⒆后又开始向停止内战、联合共产党共同反对日本帝国主义这个方面转变。这就是国民党在三个阶段上的特点。形成这些特点，当然有种种的原因。中国共产党方面，在第一次统一战线时期，它是幼年的党，它英勇地领导了一九二四年至一九二七年的革命；但在对于革命的性质、任务和方法的认识方面，却表现了它的幼年性，因此在这次革命的后期所发生的陈独秀主义⒇能够起作用，使这次革命遭受了失败。一九二七年以后，它又英勇地领导了土地革命战争，创立了革命的军队和革命的根据地，但是它也犯过冒险主义的错误，使军队和根据地都受了很大的损失。一九三五年以后，它又纠正了冒险主义的错误，领导了新的抗日的统一战线，这个伟大的斗争现在正在发展。在这个阶段上，共产党是一个经过了两次革命的考验、有了丰富的经验的党。这些就是中国共产党在三个阶段上的特点。形成这些特点也有种种的原因。不研究这些特点，就不能了解两党在各个发展阶段上的特殊的相互关系：统一战线的建立，统一战线的破裂，再一个统一战线的建立。而要研究两党的种种特点，更根本的就必须研究这两党的阶级基础以及因此在各个时期所形成的它们和其他方面的矛盾的对立。例如，国民党在它第一次联合共产党的时期，一方面有和国外帝国主义的矛盾，因而它反对帝国主义；另一方面有和国内人民大众的矛盾，它在口头上虽然允许给予劳动人民以许多的利益，但在实际上则只给予很少的利益，或者简直什么也不给。在它进行反共战争的时期，则和帝国主义、封建主义合作反对人民大众，一笔勾销了人民大众原来在革命中所争得的一切利益，激化了它和人民大众的矛盾。现在抗日时期，国民党和日本帝国主义有矛盾，它一面要联合共产党，同时它对共产党和国内人民并不放松其斗争和压迫。共产党则无论在哪一时期，均和人民大众站在一道，反对帝国主义和封建主义；但在现在的抗日时期，由于国民党表示抗日，它对国民党和国内封建势力，也就采取了缓和的政策。由于这些情况，所以或者造成了两党的联合，或者造成了两党的斗争，而且即使在两党联合的时期也有又联合又斗争的复杂的情况。如果我们不去研究这些矛盾方面的特点，我们就不但不能了解这两个党各各和其他方面的关系，也不能了解两党之间的相互关系。   
　　由此看来，不论研究何种矛盾的特性——各个物质运动形式的矛盾，各个运动形式在各个发展过程中的矛盾，各个发展过程的矛盾的各方面，各个发展过程在其各个发展阶段上的矛盾以及各个发展阶段上的矛盾的各方面，研究所有这些矛盾的特性，都不能带主观随意性，必须对它们实行具体的分析。离开具体的分析，就不能认识任何矛盾的特性。我们必须时刻记得列宁的话：对于具体的事物作具体的分析。   
　　这种具体的分析，马克思、恩格斯首先给了我们以很好的模范。   
　　当马克思、恩格斯把这事物矛盾的法则应用到社会历史过程的研究的时候，他们看出生产力和生产关系之间的矛盾，看出剥削阶级和被剥削阶级之间的矛盾以及由于这些矛盾所产生的经济基础和政治及思想等上层建筑之间的矛盾，而这些矛盾如何不可避免地会在各种不同的阶级社会中，引出各种不同的社会革命。   
　　马克思把这一法则应用到资本主义社会经济结构的研究的时候，他看出这一社会的基本矛盾在于生产的社会性和占有制的私人性之间的矛盾。这个矛盾表现于在各别企业中的生产的有组织性和在全社会中的生产的无组织性之间的矛盾。这个矛盾的阶级表现则是资产阶级和无产阶级之间的矛盾。   
　　由于事物范围的极其广大，发展的无限性，所以，在一定场合为普遍性的东西，而在另一一定场合则变为特殊性。反之，在一定场合为特殊性的东西，而在另一一定场合则变为普遍性。资本主义制度所包含的生产社会化和生产资料私人占有制的矛盾，是所有有资本主义的存在和发展的各国所共有的东西，对于资本主义说来，这是矛盾的普遍性。但是资本主义的这种矛盾，乃是一般阶级社会发展在一定历史阶段上的东西，对于一般阶级社会中的生产力和生产关系的矛盾说来，这是矛盾的特殊性。然而，当着马克思把资本主义社会这一切矛盾的特殊性解剖出来之后，同时也就更进一步地、更充分地、更完全地把一般阶级社会中这个生产力和生产关系的矛盾的普遍性阐发出来了。   
　　由于特殊的事物是和普遍的事物联结的，由于每一个事物内部不但包含了矛盾的特殊性，而且包含了矛盾的普遍性，普遍性即存在于特殊性之中，所以，当着我们研究一定事物的时候，就应当去发现这两方面及其互相联结，发现一事物内部的特殊性和普遍性的两方面及其互相联结，发现一事物和它以外的许多事物的互相联结。斯大林在他的名著《论列宁主义基础》一书中说明列宁主义的历史根源的时候，他分析了列宁主义所由产生的国际环境，分析了在帝国主义条件下已经发展到极点的资本主义的诸矛盾，以及这些矛盾使无产阶级革命成为直接实践的问题，并造成了直接冲击资本主义的良好的条件。不但如此，他又分析了为什么俄国成为列宁主义的策源地，分析了沙皇俄国当时是帝国主义一切矛盾的集合点以及俄国无产阶级所以能够成为国际的革命无产阶级的先锋队的原因。这样，斯大林分析了帝国主义的矛盾的普遍性，说明列宁主义是帝国主义和无产阶级革命时代的马克思主义；又分析了沙俄帝国主义在这一般矛盾中所具有的特殊性，说明俄国成了无产阶级革命理论和策略的故乡，而在这种特殊性中间就包含了矛盾的普遍性。斯大林的这种分析，给我们提供了认识矛盾的特殊性和普遍性及其互相联结的模范。   
　　马克思和恩格斯，同样地列宁和斯大林，他们对于应用辩证法到客观现象的研究的时候，总是指导人们不要带上任何的主观随意性，而必须从客观的实际运动所包含的具体的条件，去看出这些现象中的具体的矛盾、矛盾各方面的具体的地位以及矛盾的具体的相互关系。我们的教条主义者因为没有这种研究态度，所以弄得一无是处。我们必须以教条主义的失败为鉴戒，学会这种研究态度，舍此没有第二种研究法。   
　　矛盾的普遍性和矛盾的特殊性的关系，就是矛盾的共性和个性的关系。其共性是矛盾存在于一切过程中，并贯串于一切过程的始终，矛盾即是运动，即是事物，即是过程，也即是思想。否认事物的矛盾就是否认了一切。这是共通的道理，古今中外，概莫能外。所以它是共性，是绝对性。然而这种共性，即包含于一切个性之中，无个性即无共性。假如除去一切个性，还有什么共性呢？因为矛盾的各各特殊，所以造成了个性。一切个性都是有条件地暂时地存在的，所以是相对的。   
　　这一共性个性、绝对相对的道理，是关于事物矛盾的问题的精髓，不懂得它，就等于抛弃了辩证法。   
## 四　主要的矛盾和主要的矛盾方面  

  
　　在矛盾特殊性的问题中，还有两种情形必须特别地提出来加以分析，这就是主要的矛盾和主要的矛盾方面。   
　　在复杂的事物的发展过程中，有许多的矛盾存在，其中必有一种是主要的矛盾，由于它的存在和发展规定或影响着其他矛盾的存在和发展。   
　　例如在资本主义社会中，无产阶级和资产阶级这两个矛盾着的力量是主要的矛盾；其他的矛盾力量，例如，残存的封建阶级和资产阶级的矛盾，农民小资产者和资产阶级的矛盾，无产阶级和农民小资产者的矛盾，自由资产阶级和垄断资产阶级的矛盾，资产阶级的民主主义和资产阶级的法西斯主义的矛盾，资本主义国家相互间的矛盾，帝国主义和殖民地的矛盾，以及其他的矛盾，都为这个主要的矛盾力量所规定、所影响。   
　　半殖民地的国家如中国，其主要矛盾和非主要矛盾的关系呈现着复杂的情况。   
　　当着帝国主义向这种国家举行侵略战争的时候，这种国家的内部各阶级，除开一些叛国分子以外，能够暂时地团结起来举行民族战争去反对帝国主义。这时，帝国主义和这种国家之间的矛盾成为主要的矛盾，而这种国家内部各阶级的一切矛盾（包括封建制度和人民大众之间这个主要矛盾在内），便都暂时地降到次要和服从的地位。中国一八四〇年的鸦片战争（21），一八九四年的中日战争（22），一九〇〇年的义和团战争（23）和目前的中日战争，都有这种情形。   
　　然而在另一种情形之下，则矛盾的地位起了变化。当着帝国主义不是用战争压迫而是用政治、经济、文化等比较温和的形式进行压迫的时候，半殖民地国家的统治阶级就会向帝国主义投降，二者结成同盟，共同压迫人民大众。这种时候，人民大众往往采取国内战争的形式，去反对帝国主义和封建阶级的同盟，而帝国主义则往往采取间接的方式去援助半殖民地国家的反动派压迫人民，而不采取直接行动，显出了内部矛盾的特别尖锐性。中国的辛亥革命战争，一九二四年至一九二七年的革命战争，一九二七年以后的十年土地革命战争，都有这种情形。还有半殖民地国家各个反动的统治集团之间的内战，例如在中国的军阀战争，也属于这一类。   
　　当着国内革命战争发展到从根本上威胁帝国主义及其走狗国内反动派的存在的时候，帝国主义就往往采取上述方法以外的方法，企图维持其统治：或者分化革命阵线的内部，或者直接出兵援助国内反动派。这时，外国帝国主义和国内反动派完全公开地站在一个极端，人民大众则站在另一极端，成为一个主要矛盾，而规定或影响其他矛盾的发展状态。十月革命后各资本主义国家援助俄国反动派，是武装干涉的例子。一九二七年的蒋介石的叛变，是分化革命阵线的例子。   
　　然而不管怎样，过程发展的各个阶段中，只有一种主要的矛盾起着领导的作用，是完全没有疑义的。   
　　由此可知，任何过程如果有多数矛盾存在的话，其中必定有一种是主要的，起着领导的、决定的作用，其他则处于次要和服从的地位。因此，研究任何过程，如果是存在着两个以上矛盾的复杂过程的话，就要用全力找出它的主要矛盾。捉住了这个主要矛盾，一切问题就迎刃而解了。这是马克思研究资本主义社会告诉我们的方法。列宁和斯大林研究帝国主义和资本主义总危机的时候，列宁和斯大林研究苏联经济的时候，也告诉了这种方法。万千的学问家和实行家，不懂得这种方法，结果如堕烟海，找不到中心，也就找不到解决矛盾的方法。   
　　不能把过程中所有的矛盾平均看待，必须把它们区别为主要的和次要的两类，着重于捉住主要的矛盾，已如上述。但是在各种矛盾之中，不论是主要的或次要的，矛盾着的两个方面，又是否可以平均看待呢？也是不可以的。无论什么矛盾，矛盾的诸方面，其发展是不平衡的。有时候似乎势均力敌，然而这只是暂时的和相对的情形，基本的形态则是不平衡。矛盾着的两方面中，必有一方面是主要的，他方面是次要的。其主要的方面，即所谓矛盾起主导作用的方面。事物的性质，主要地是由取得支配地位的矛盾的主要方面所规定的。   
　　然而这种情形不是固定的，矛盾的主要和非主要的方面互相转化着，事物的性质也就随着起变化。在矛盾发展的一定过程或一定阶段上，主要方面属于甲方，非主要方面属于乙方；到了另一发展阶段或另一发展过程时，就互易其位置，这是依靠事物发展中矛盾双方斗争的力量的增减程度来决定的。   
　　我们常常说“新陈代谢”这句话。新陈代谢是宇宙间普遍的永远不可抵抗的规律。依事物本身的性质和条件，经过不同的飞跃形式，一事物转化为他事物，就是新陈代谢的过程。任何事物的内部都有其新旧两个方面的矛盾，形成为一系列的曲折的斗争。斗争的结果，新的方面由小变大，上升为支配的东西；旧的方面则由大变小，变成逐步归于灭亡的东西。而一当新的方面对于旧的方面取得支配地位的时候，旧事物的性质就变化为新事物的性质。由此可见，事物的性质主要地是由取得支配地位的矛盾的主要方面所规定的。取得支配地位的矛盾的主要方面起了变化，事物的性质也就随着起变化。   
　　在资本主义社会中，资本主义已从旧的封建主义社会时代的附庸地位，转化成了取得支配地位的力量，社会的性质也就由封建主义的变为资本主义的。在新的资本主义社会时代，封建势力则由原来处在支配地位的力量转化为附庸的力量，随着也就逐步地归于消灭了，例如英法诸国就是如此。随着生产力的发展，资产阶级由新的起进步作用的阶级，转化为旧的起反动作用的阶级，以至于最后被无产阶级所推翻，而转化为私有的生产资料被剥夺和失去权力的阶级，这个阶级也就要逐步归于消灭了。人数比资产阶级多得多、并和资产阶级同时生长、但被资产阶级统治着的无产阶级，是一个新的力量，它由初期的附属于资产阶级的地位，逐步地壮大起来，成为独立的和在历史上起主导作用的阶级，以至最后夺取政权成为统治阶级。这时，社会的性质，就由旧的资本主义的社会转化成了新的社会主义的社会。这就是苏联已经走过和一切其他国家必然要走的道路。   
　　就中国的情形来说，帝国主义处在形成半殖民地这种矛盾的主要地位，压迫中国人民，中国则由独立国变为半殖民地。然而事情必然会变化，在双方斗争的局势中，中国人民在无产阶级领导之下所生长起来的力量必然会把中国由半殖民地变为独立国，而帝国主义则将被打倒，旧中国必然要变为新中国。   
　　旧中国变为新中国，还包含着国内旧的封建势力和新的人民势力之间的情况的变化。旧的封建地主阶级将被打倒，由统治者变为被统治者，这个阶级也就会要逐步归于消灭。人民则将在无产阶级领导之下，由被统治者变为统治者。这时，中国社会的性质就会起变化，由旧的半殖民地和半封建的社会变为新的民主的社会。   
　　这种互相转化的事情，过去已有经验。统治中国将近三百年的清朝帝国，曾在辛亥革命时期被打倒；而孙中山领导的革命同盟会，则曾经一度取得了胜利。在一九二四年至一九二七年的革命战争中，共产党和国民党联合的南方革命势力，曾经由弱小的力量变得强大起来，取得了北伐的胜利；而称雄一时的北洋军阀则被打倒了。一九二七年，共产党领导的人民力量，受了国民党反动势力的打击，变得很小了；但因肃清了自己内部的机会主义，就又逐步地壮大起来。在共产党领导的革命根据地内，农民由被统治者转化为统治者，地主则作了相反的转化。世界上总是这样以新的代替旧的，总是这样新陈代谢、除旧布新或推陈出新的。   
　　革命斗争中的某些时候，困难条件超过顺利条件，在这种时候，困难是矛盾的主要方面，顺利是其次要方面。然而由于革命党人的努力，能够逐步地克服困难，开展顺利的新局面，困难的局面让位于顺利的局面。一九二七年中国革命失败后的情形，中国红军在长征（24）中的情形，都是如此。现在的中日战争，中国又处在困难地位，但是我们能够改变这种情况，使中日双方的情况发生根本的变化。在相反的情形之下，顺利也能转化为困难，如果是革命党人犯了错误的话。一九二四年至一九二七年的革命的胜利，变为失败了。一九二七年以后在南方各省发展起来的革命根据地，至一九三四年都失败了。   
　　研究学问的时候，由不知到知的矛盾也是如此。当着我们刚才开始研究马克思主义的时候，对于马克思主义的无知或知之不多的情况，和马克思主义的知识之间，互相矛盾着。然而由于努力学习，可以由无知转化为有知，由知之不多转化为知之甚多，由对于马克思主义的盲目性改变为能够自由运用马克思主义。   
　　有人觉得有些矛盾并不是这样。例如，生产力和生产关系的矛盾，生产力是主要的；理论和实践的矛盾，实践是主要的；经济基础和上层建筑的矛盾，经济基础是主要的：它们的地位并不互相转化。这是机械唯物论的见解，不是辩证唯物论的见解。诚然，生产力、实践、经济基础，一般地表现为主要的决定的作用，谁不承认这一点，谁就不是唯物论者。然而，生产关系、理论、上层建筑这些方面，在一定条件之下，又转过来表现其为主要的决定的作用，这也是必须承认的。当着不变更生产关系，生产力就不能发展的时候，生产关系的变更就起了主要的决定的作用。当着如同列宁所说“没有革命的理论，就不会有革命的运动”（25）的时候，革命理论的创立和提倡就起了主要的决定的作用。当着某一件事情（任何事情都是一样）要做，但是还没有方针、方法、计划或政策的时候，确定方针、方法、计划或政策，也就是主要的决定的东西。当着政治文化等等上层建筑阻碍着经济基础的发展的时候，对于政治上和文化上的革新就成为主要的决定的东西了。我们这样说，是否违反了唯物论呢？没有。因为我们承认总的历史发展中是物质的东西决定精神的东西，是社会的存在决定社会的意识；但是同时又承认而且必须承认精神的东西的反作用，社会意识对于社会存在的反作用，上层建筑对于经济基础的反作用。这不是违反唯物论，正是避免了机械唯物论，坚持了辩证唯物论。   
　　在研究矛盾特殊性的问题中，如果不研究过程中主要的矛盾和非主要的矛盾以及矛盾之主要的方面和非主要的方面这两种情形，也就是说不研究这两种矛盾情况的差别性，那就将陷入抽象的研究，不能具体地懂得矛盾的情况，因而也就不能找出解决矛盾的正确的方法。这两种矛盾情况的差别性或特殊性，都是矛盾力量的不平衡性。世界上没有绝对地平衡发展的东西，我们必须反对平衡论，或均衡论。同时，这种具体的矛盾状况，以及矛盾的主要方面和非主要方面在发展过程中的变化，正是表现出新事物代替旧事物的力量。对于矛盾的各种不平衡情况的研究，对于主要的矛盾和非主要的矛盾、主要的矛盾方面和非主要的矛盾方面的研究，成为革命政党正确地决定其政治上和军事上的战略战术方针的重要方法之一，是一切共产党人都应当注意的。   
## 五　矛盾诸方面的同一性和斗争性  

  
　　在懂得了矛盾的普遍性和特殊性的问题之后，我们必须进而研究矛盾诸方面的同一性和斗争性的问题。   
　　同一性、统一性、一致性、互相渗透、互相贯通、互相依赖（或依存）、互相联结或互相合作，这些不同的名词都是一个意思，说的是如下两种情形：第一、事物发展过程中的每一种矛盾的两个方面，各以和它对立着的方面为自己存在的前提，双方共处于一个统一体中；第二、矛盾着的双方，依据一定的条件，各向着其相反的方面转化。这些就是所谓同一性。   
　　列宁说：“辩证法是这样的一种学说：它研究对立怎样能够是同一的，又怎样成为同一的（怎样变成同一的），——在怎样的条件之下它们互相转化，成为同一的，——为什么人的头脑不应当把这些对立看作死的、凝固的东西，而应当看作生动的、有条件的、可变动的、互相转化的东西。”（26）   
　　列宁这段话是什么意思呢？   
　　一切过程中矛盾着的各方面，本来是互相排斥、互相斗争、互相对立的。世界上一切事物的过程里和人们的思想里，都包含着这样带矛盾性的方面，无一例外。单纯的过程只有一对矛盾，复杂的过程则有一对以上的矛盾。各对矛盾之间，又互相成为矛盾。这样地组成客观世界的一切事物和人们的思想，并推使它们发生运动。   
　　如此说来，只是极不同一，极不统一，怎样又说是同一或统一呢？   
　　原来矛盾着的各方面，不能孤立地存在。假如没有和它作对的矛盾的一方，它自己这一方就失去了存在的条件。试想一切矛盾着的事物或人们心中矛盾着的概念，任何一方面能够独立地存在吗？没有生，死就不见；没有死，生也不见。没有上，无所谓下；没有下，也无所谓上。没有祸，无所谓福；没有福，也无所谓祸。没有顺利，无所谓困难；没有困难，也无所谓顺利。没有地主，就没有佃农；没有佃农，也就没有地主。没有资产阶级，就没有无产阶级；没有无产阶级，也就没有资产阶级。没有帝国主义的民族压迫，就没有殖民地和半殖民地；没有殖民地和半殖民地，也就没有帝国主义的民族压迫。一切对立的成分都是这样，因一定的条件，一面互相对立，一面又互相联结、互相贯通、互相渗透、互相依赖，这种性质，叫做同一性。一切矛盾着的方面都因一定条件具备着不同一性，所以称为矛盾。然而又具备着同一性，所以互相联结。列宁所谓辩证法研究“对立怎样能够是同一的”，就是说的这种情形。怎样能够呢？因为互为存在的条件。这是同一性的第一种意义。   
　　然而单说了矛盾双方互为存在的条件，双方之间有同一性，因而能够共处于一个统一体中，这样就够了吗？还不够。事情不是矛盾双方互相依存就完了，更重要的，还在于矛盾着的事物的互相转化。这就是说，事物内部矛盾着的两方面，因为一定的条件而各向着和自己相反的方面转化了去，向着它的对立方面所处的地位转化了去。这就是矛盾的同一性的第二种意义。   
　　为什么这里也有同一性呢？你们看，被统治的无产阶级经过革命转化为统治者，原来是统治者的资产阶级却转化为被统治者，转化到对方原来所占的地位。苏联已经是这样做了，全世界也将要这样做。试问其间没有在一定条件之下的联系和同一性，如何能够发生这样的变化呢？   
　　曾在中国近代历史的一定阶段上起过某种积极作用的国民党，因为它的固有的阶级性和帝国主义的引诱（这些就是条件），在一九二七年以后转化为反革命，又由于中日矛盾的尖锐化和共产党的统一战线政策（这些就是条件），而被迫着赞成抗日。矛盾着的东西这一个变到那一个，其间包含了一定的同一性。   
　　我们实行过的土地革命，已经是并且还将是这样的过程，拥有土地的地主阶级转化为失掉土地的阶级，而曾经是失掉土地的农民却转化为取得土地的小私有者。有无、得失之间，因一定条件而互相联结，二者具有同一性。在社会主义条件之下，农民的私有制又将转化为社会主义农业的公有制，苏联已经这样做了，全世界将来也会这样做。私产和公产之间有一条由此达彼的桥梁，哲学上名之曰同一性，或互相转化、互相渗透。   
　　巩固无产阶级的专政或人民的专政，正是准备着取消这种专政，走到消灭任何国家制度的更高阶段去的条件。建立和发展共产党，正是准备着消灭共产党和一切政党制度的条件。建立共产党领导的革命军，进行革命战争，正是准备着永远消灭战争的条件。这许多相反的东西，同时却是相成的东西。   
　　大家知道，战争与和平是互相转化的。战争转化为和平，例如第一次世界大战转化为战后的和平，中国的内战现在也停止了，出现了国内的和平。和平转化为战争，例如一九二七年的国共合作转化为战争，现在的世界和平局面也可能转化为第二次世界大战。为什么是这样？因为在阶级社会中战争与和平这样矛盾着的事物，在一定条件下具备着同一性。   
　　一切矛盾着的东西，互相联系着，不但在一定条件之下共处于一个统一体中，而且在一定条件之下互相转化，这就是矛盾的同一性的全部意义。列宁所谓“怎样成为同一的（怎样变成同一的），——在怎样的条件之下它们互相转化，成为同一的”，就是这个意思。   
　　“为什么人的头脑不应当把这些对立看作死的、凝固的东西，而应当看作生动的、有条件的、可变动的、互相转化的东西”呢？因为客观事物本来是如此的。客观事物中矛盾着的诸方面的统一或同一性，本来不是死的、凝固的，而是生动的、有条件的、可变动的、暂时的、相对的东西，一切矛盾都依一定条件向它们的反面转化着。这种情况，反映在人们的思想里，就成了马克思主义的唯物辩证法的宇宙观。只有现在的和历史上的反动的统治阶级以及为他们服务的形而上学，不是把对立的事物当作生动的、有条件的、可变动的、互相转化的东西去看，而是当作死的、凝固的东西去看，并且把这种错误的看法到处宣传，迷惑人民群众，以达其继续统治的目的。共产党人的任务就在于揭露反动派和形而上学的错误思想，宣传事物的本来的辩证法，促成事物的转化，达到革命的目的。   
　　所谓矛盾在一定条件下的同一性，就是说，我们所说的矛盾乃是现实的矛盾，具体的矛盾，而矛盾的互相转化也是现实的、具体的。神话中的许多变化，例如《山海经》中所说的“夸父追日”（27），《淮南子》中所说的“羿射九日”（28），《西游记》中所说的孙悟空七十二变（29）和《聊斋志异》（30）中的许多鬼狐变人的故事等等，这种神话中所说的矛盾的互相变化，乃是无数复杂的现实矛盾的互相变化对于人们所引起的一种幼稚的、想象的、主观幻想的变化，并不是具体的矛盾所表现出来的具体的变化。马克思说：“任何神话都是用想象和借助想象以征服自然力，支配自然力，把自然力加以形象化；因而，随着这些自然力之实际上被支配，神话也就消失了。”（31）这种神话中的（还有童话中的）千变万化的故事，虽然因为它们想象出人们征服自然力等等，而能够吸引人们的喜欢，并且最好的神话具有“永久的魅力”（32）（马克思），但神话并不是根据具体的矛盾之一定的条件而构成的，所以它们并不是现实之科学的反映。这就是说，神话或童话中矛盾构成的诸方面，并不是具体的同一性，只是幻想的同一性。科学地反映现实变化的同一性的，就是马克思主义的辩证法。   
　　为什么鸡蛋能够转化为鸡子，而石头不能够转化为鸡子呢？为什么战争与和平有同一性，而战争与石头却没有同一性呢？为什么人能生人不能生出其他的东西呢？没有别的，就是因为矛盾的同一性要在一定的必要的条件之下。缺乏一定的必要的条件，就没有任何的同一性。   
　　为什么俄国在一九一七年二月的资产阶级民主革命和同年十月的无产阶级社会主义革命直接地联系着，而法国资产阶级革命没有直接地联系于社会主义的革命，一八七一年的巴黎公社终于失败了呢？为什么蒙古和中亚细亚的游牧制度又直接地和社会主义联系了呢？为什么中国的革命可以避免资本主义的前途，可以和社会主义直接联系起来，不要再走西方国家的历史老路，不要经过一个资产阶级专政的时期呢？没有别的，都是由于当时的具体条件。一定的必要的条件具备了，事物发展的过程就发生一定的矛盾，而且这种或这些矛盾互相依存，又互相转化，否则，一切都不可能。   
　　同一性的问题如此。那末，什么是斗争性呢？同一性和斗争性的关系是怎样的呢？   
　　列宁说：“对立的统一（一致、同一、合一），是有条件的、一时的、暂存的、相对的。互相排斥的对立的斗争则是绝对的，正如发展、运动是绝对的一样。”（33）   
　　列宁这段话是什么意思呢？   
　　一切过程都有始有终，一切过程都转化为它们的对立物。一切过程的常住性是相对的，但是一种过程转化为他种过程的这种变动性则是绝对的。   
　　无论什么事物的运动都采取两种状态，相对地静止的状态和显著地变动的状态。两种状态的运动都是由事物内部包含的两个矛盾着的因素互相斗争所引起的。当着事物的运动在第一种状态的时候，它只有数量的变化，没有性质的变化，所以显出好似静止的面貌。当着事物的运动在第二种状态的时候，它已由第一种状态中的数量的变化达到了某一个最高点，引起了统一物的分解，发生了性质的变化，所以显出显著地变化的面貌。我们在日常生活中所看见的统一、团结、联合、调和、均势、相持、僵局、静止、有常、平衡、凝聚、吸引等等，都是事物处在量变状态中所显现的面貌。而统一物的分解，团结、联合、调和、均势、相持、僵局、静止、有常、平衡、凝聚、吸引等等状态的破坏，变到相反的状态，便都是事物在质变状态中、在一种过程过渡到他种过程的变化中所显现的面貌。事物总是不断地由第一种状态转化为第二种状态，而矛盾的斗争则存在于两种状态中，并经过第二种状态而达到矛盾的解决。所以说，对立的统一是有条件的、暂时的、相对的，而对立的互相排除的斗争则是绝对的。   
　　前面我们曾经说，两个相反的东西中间有同一性，所以二者能够共处于一个统一体中，又能够互相转化，这是说的条件性，即是说在一定条件之下，矛盾的东西能够统一起来，又能够互相转化；无此一定条件，就不能成为矛盾，不能共居，也不能转化。由于一定的条件才构成了矛盾的同一性，所以说同一性是有条件的、相对的。这里我们又说，矛盾的斗争贯串于过程的始终，并使一过程向着他过程转化，矛盾的斗争无所不在，所以说矛盾的斗争性是无条件的、绝对的。   
　　有条件的相对的同一性和无条件的绝对的斗争性相结合，构成了一切事物的矛盾运动。   
　　我们中国人常说：“相反相成。”（34）就是说相反的东西有同一性。这句话是辩证法的，是违反形而上学的。“相反”就是说两个矛盾方面的互相排斥，或互相斗争。“相成”就是说在一定条件之下两个矛盾方面互相联结起来，获得了同一性。而斗争性即寓于同一性之中，没有斗争性就没有同一性。   
　　在同一性中存在着斗争性，在特殊性中存在着普遍性，在个性中存在着共性。拿列宁的话来说，叫做“在相对的东西里面有着绝对的东西”（35）。   
## 六　对抗在矛盾中的地位  

  
　　在矛盾的斗争性的问题中，包含着对抗是什么的问题。我们回答道：对抗是矛盾斗争的一种形式，而不是矛盾斗争的一切形式。   
　　在人类历史中，存在着阶级的对抗，这是矛盾斗争的一种特殊的表现。剥削阶级和被剥削阶级之间的矛盾，无论在奴隶社会也好，封建社会也好，资本主义社会也好，互相矛盾着的两阶级，长期地并存于一个社会中，它们互相斗争着，但要待两阶级的矛盾发展到了一定的阶段的时候，双方才取外部对抗的形式，发展为革命。阶级社会中，由和平向战争的转化，也是如此。   
　　炸弹在未爆炸的时候，是矛盾物因一定条件共居于一个统一体中的时候。待至新的条件（发火）出现，才发生了爆炸。自然界中一切到了最后要采取外部冲突形式去解决旧矛盾产生新事物的现象，都有与此相仿佛的情形。   
　　认识这种情形，极为重要。它使我们懂得，在阶级社会中，革命和革命战争是不可避免的，舍此不能完成社会发展的飞跃，不能推翻反动的统治阶级，而使人民获得政权。共产党人必须揭露反动派所谓社会革命是不必要的和不可能的等等欺骗的宣传，坚持马克思列宁主义的社会革命论，使人民懂得，这不但是完全必要的，而且是完全可能的，整个人类的历史和苏联的胜利，都证明了这个科学的真理。   
　　但是我们必须具体地研究各种矛盾斗争的情况，不应当将上面所说的公式不适当地套在一切事物的身上。矛盾和斗争是普遍的、绝对的，但是解决矛盾的方法，即斗争的形式，则因矛盾的性质不同而不相同。有些矛盾具有公开的对抗性，有些矛盾则不是这样。根据事物的具体发展，有些矛盾是由原来还非对抗性的，而发展成为对抗性的；也有些矛盾则由原来是对抗性的，而发展成为非对抗性的。   
　　共产党内正确思想和错误思想的矛盾，如前所说，在阶级存在的时候，这是阶级矛盾对于党内的反映。这种矛盾，在开始的时候，或在个别的问题上，并不一定马上表现为对抗性的。但随着阶级斗争的发展，这种矛盾也就可能发展为对抗性的。苏联共产党的历史告诉我们：列宁、斯大林的正确思想和托洛茨基、布哈林等人的错误思想的矛盾，在开始的时候还没有表现为对抗的形式，但随后就发展为对抗的了。中国共产党的历史也有过这样的情形。我们党内许多同志的正确思想和陈独秀、张国焘（36）等人的错误思想的矛盾，在开始的时候也没有表现为对抗的形式，但随后就发展为对抗的了。目前我们党内的正确思想和错误思想的矛盾，没有表现为对抗的形式，如果犯错误的同志能够改正自己的错误，那就不会发展为对抗性的东西。因此，党一方面必须对于错误思想进行严肃的斗争，另方面又必须充分地给犯错误的同志留有自己觉悟的机会。在这样的情况下，过火的斗争，显然是不适当的。但如果犯错误的人坚持错误，并扩大下去，这种矛盾也就存在着发展为对抗性的东西的可能性。   
　　经济上城市和乡村的矛盾，在资本主义社会里面（那里资产阶级统治的城市残酷地掠夺乡村），在中国的国民党统治区域里面（那里外国帝国主义和本国买办大资产阶级所统治的城市极野蛮地掠夺乡村），那是极其对抗的矛盾。但在社会主义国家里面，在我们的革命根据地里面，这种对抗的矛盾就变为非对抗的矛盾，而当到达共产主义社会的时候，这种矛盾就会消灭。   
　　列宁说：“对抗和矛盾断然不同。在社会主义下，对抗消灭了，矛盾存在着。”（37）这就是说，对抗只是矛盾斗争的一种形式，而不是它的一切形式，不能到处套用这个公式。   
## 七　结　　论  

  
　　说到这里，我们可以总起来说几句。事物矛盾的法则，即对立统一的法则，是自然和社会的根本法则，因而也是思维的根本法则。它是和形而上学的宇宙观相反的。它对于人类的认识史是一个大革命。按照辩证唯物论的观点看来，矛盾存在于一切客观事物和主观思维的过程中，矛盾贯串于一切过程的始终，这是矛盾的普遍性和绝对性。矛盾着的事物及其每一个侧面各有其特点，这是矛盾的特殊性和相对性。矛盾着的事物依一定的条件有同一性，因此能够共居于一个统一体中，又能够互相转化到相反的方面去，这又是矛盾的特殊性和相对性。然而矛盾的斗争则是不断的，不管在它们共居的时候，或者在它们互相转化的时候，都有斗争的存在，尤其是在它们互相转化的时候，斗争的表现更为显著，这又是矛盾的普遍性和绝对性。当着我们研究矛盾的特殊性和相对性的时候，要注意矛盾和矛盾方面的主要的和非主要的区别；当着我们研究矛盾的普遍性和斗争性的时候，要注意矛盾的各种不同的斗争形式的区别。否则就要犯错误。如果我们经过研究真正懂得了上述这些要点，我们就能够击破违反马克思列宁主义基本原则的不利于我们的革命事业的那些教条主义的思想；也能够使有经验的同志们整理自己的经验，使之带上原则性，而避免重复经验主义的错误。这些，就是我们研究矛盾法则的一些简单的结论。   
  
------------------  
　　注　　释   
　　〔1〕 见列宁《黑格尔〈哲学史讲演录〉一书摘要》（《列宁全集》第55卷，人民出版社1990年版，第213页）。   
　　〔2〕参见列宁《谈谈辩证法问题》：“统一物之分为两个部分以及对它的矛盾着的部分的认识……，是辩证法的实质（是辩证法的‘本质’之一，是它的基本的特点或特征之一，甚至可说是它的最基本的特点或特征）。”并参见《黑格尔〈逻辑学〉一书摘要》中关于“辩证法的要素”部分：“可以把辩证法简要地规定为关于对立面的统一的学说。这样就会抓住辩证法的核心，可是这需要说明和发挥。”（《列宁全集》第55卷，人民出版社1990年版，第305、192页）   
　　〔3〕德波林（一八八一——一九六三），苏联哲学家。一九二九年当选为苏联科学院院士。三十年代初，苏联哲学界发动对德波林学派的批判，认为他们犯了理论脱离实践、哲学脱离政治等唯心主义性质的错误。   
　　〔4〕见列宁《谈谈辩证法问题》。新的译文是：“有两种基本的（或两种可能的？或两种在历史上常见的？）发展（进化）观点：认为发展是减少和增加，是重复；以及认为发展是对立面的统一（统一物之分为两个互相排斥的对立面以及它们之间的相互关系）。”（《列宁全集》第55卷，人民出版社1990年版，第306页）   
　　〔5〕见《汉书·董仲舒传》。董仲舒（公元前一七九——前一〇四）是孔子学派在西汉的主要代表，他曾经对汉武帝说：“道之大原出于天，天不变，道亦不变。”“道”是中国古代哲学家的通用语，它的意义是“道路”或“道理”，可作“法则”或“规律”解说。   
　　〔6〕 见恩格斯《反杜林论》第一编第十二节《辩证法。量和质》（《马克思恩格斯选集》第3卷，人民出版社1972年版，第160页）。   
　　〔7〕见列宁《谈谈辩证法问题》。新的译文是：“承认（发现）自然界的（也包括精神的和社会的）一切现象和过程具有矛盾着的、相互排斥的、对立的倾向。”（《列宁全集》第55卷，人民出版社1990年版，第306页）   
　　〔8〕以上所引恩格斯的三段话，均见恩格斯《反杜林论》第一编第十二节《辩证法。量和质》。其中第二段“高等数学的主要基础之一，就是矛盾……”，《反杜林论》中的原文是：“我们已经提到，高等数学的主要基础之一是这样一个矛盾：在一定条件下直线和曲线应当是一回事。高等数学还有另一个矛盾：在我们眼前相交的线，只要离开交点五六厘米，就应当认为是平行的、即使无限延长也不会相交的线。可是，高等数学利用这些和其他一些更加尖锐的矛盾获得了不仅是正确的、而且是初等数学所完全不能达到的成果。”（《马克思恩格斯选集》第3卷，人民出版社1972年版，第160—161页）   
　　〔9〕 见列宁《谈谈辩证法问题》（《列宁全集》第55卷，人民出版社1990年版，第305—306页）。   
　　〔10〕见列宁《谈谈辩证法问题》（《列宁全集》第55卷，人民出版社1990年版，第307页）。   
　　〔11〕 参见本卷《中国革命战争的战略问题》注〔11〕。   
　　〔12〕 见《孙子·谋攻》。   
　　〔13〕 魏徵（五八〇——六四三），唐代初期的政治活动家和历史学家。本文引语见《资治通鉴》卷一百九十二。   
　　〔14〕《水浒传》是中国描写农民战争的著名小说。宋江是这部小说中农民武装的主要领袖。祝家庄在农民武装根据地梁山泊的附近，这个庄的统治者祝朝奉，是一个大恶霸地主。   
　　〔15〕木马计是希腊神话中的一个著名故事。据传说，古希腊人攻打特洛伊城，很久打不下来。后来，他们伪装撤退，在城下营房中留下了一匹腹内藏有一批勇士的大木马。特洛伊人不知道这是敌人的计策，把木马作为战利品拉进城去。深夜，勇士们走出木马，利用特洛伊人毫无戒备的时机，配合城外的军队，迅速地夺取了特洛伊城。   
　　〔16〕见列宁《再论工会、目前局势及托洛茨基同志和布哈林同志的错误》。新的译文是：“要真正地认识事物，就必须把握住、研究清楚它的一切方面、一切联系和‘中介’。我们永远也不会完全做到这一点，但是，全面性这一要求可以使我们防止犯错误和防止僵化。”（《列宁全集》第40卷，人民出版社1986年版，第291页）   
　　〔17〕 见本卷《湖南农民运动考察报告》注〔3〕。   
　　〔18〕 见本卷《论反对日本帝国主义的策略》注〔5〕。   
　　〔19〕参见本卷《关于蒋介石声明的声明》注〔1〕。   
　　〔20〕 见本卷《中国革命战争的战略问题》注〔4〕。   
　　〔21〕见本卷《论反对日本帝国主义的策略》注〔35〕。   
　　〔22〕一八九四年（甲午年）发生的中日战争，也称甲午战争。这次战争是日本军国主义者蓄意挑起的。日本军队先向朝鲜发动侵略并对中国的陆海军进行挑衅，继即大举侵入中国的东北。在战争中，中国军队曾经英勇作战，但是由于清朝政府的腐败以及缺乏坚决反对侵略的准备，中国方面遭到了失败。一八九五年，清朝政府和日本订立了可耻的马关条约，这个条约的主要内容是：中国割让台湾全岛及所有附属各岛屿、澎湖列岛和辽东半岛（后来在俄、德、法三国干涉下，日本同意由清政府偿付白银三千万两“赎还”该半岛），赔偿军费银二万万两，允许日本人在中国通商口岸开设工厂，开辟沙市、重庆、苏州、杭州等地为商埠。   
　　〔23〕 见本卷《论反对日本帝国主义的策略》注〔37〕。   
　　〔24〕 参见本卷《论反对日本帝国主义的策略》注〔22〕。   
　　〔25〕见列宁《俄国社会民主党人的任务》（《列宁全集》第2卷，人民出版社1984年版，第443页）；并见列宁《怎么办？》第一章第四节（《列宁全集》第6卷，人民出版社1986年版，第23页）。   
　　〔26〕见列宁《黑格尔〈逻辑学〉一书摘要》。新的译文是：“辩证法是一种学说，它研究对立面怎样才能够同一，是怎样（怎样成为）同一的——在什么条件下它们是相互转化而同一的，——为什么人的头脑不应该把这些对立面看作僵死的、凝固的东西，而应该看作活生生的、有条件的、活动的、彼此转化的东西。”（《列宁全集》第55卷，人民出版社1990年版，第90页）   
　　〔27〕《山海经》是一部中国古代地理著作，其中记载了不少远古的神话传说。夸父是《山海经·海外北经》上记载的一个神人。据说：“夸父与日逐走。入日，渴欲得饮，饮于河渭。河渭不足，北饮大泽。未至，道渴而死。弃其杖，化为邓林。”   
　　〔28〕羿是中国古代传说中的英雄，“射日”是关于他善射的著名故事。据西汉淮南王刘安（公元前二世纪人）及其门客所著《淮南子》一书说：“尧之时，十日并出，焦禾稼，杀草木，而民无所食。猰豸、凿齿、九婴、大风、封狶、修蛇，皆为民害。尧乃使羿……上射十日而下杀猰豸。……万民皆喜。”东汉著作家王逸（公元二世纪人）关于屈原诗篇《天问》的注释说：“淮南言，尧时十日并出，草木焦枯。尧命羿仰射十日，中其九日……留其一日。”   
　　〔29〕《西游记》是明代作家吴承恩著的一部神话小说。孙悟空是书中的主角。他是一个神猴，有七十二变的法术，能够随意变成各式各样的鸟兽虫鱼草木器物或者人形。   
　　〔30〕 《聊斋志异》是清代文学家蒲松龄著的短篇小说集，大部分是叙述神仙狐鬼的故事。   
　　〔31〕见马克思《〈政治经济学批判〉导言》（《马克思恩格斯选集》第2卷，人民出版社1972年版，第113页）。   
　　〔32〕见马克思《〈政治经济学批判〉导言》（《马克思恩格斯选集》第2卷，人民出版社1972年版，第114页）。   
　　〔33〕见列宁《谈谈辩证法问题》。新的译文是：“对立面的统一（一致、同一、均势）是有条件的、暂时的、易逝的、相对的。相互排斥的对立面的斗争是绝对的，正如发展、运动是绝对的一样。”（《列宁全集》第55卷，人民出版社1990年版，第306页）   
　　〔34〕见东汉著名史学家班固（三二——九二）所著《汉书·艺文志》，原文是：“诸子十家，其可观者，九家而已。皆起于王道既微，诸侯力政，时君世主，好恶殊方。是以九家之术，蜂出并作，各引一端，崇其所善，以此驰说，取合诸侯。其言虽殊，辟犹水火，相灭亦相生也。仁之与义，敬之与和，相反而皆相成也。”   
　　〔35〕 见列宁《谈谈辩证法问题》。新的译文是：“相对中有绝对。”（《列宁全集》第55卷，人民出版社1990年版，第307页）   
　　〔36〕见本卷《论反对日本帝国主义的策略》注〔24〕。   
　　〔37〕见列宁《在尼·布哈林〈过渡时期经济学〉一书上作的批注和评论》（《列宁全集》第60卷，人民出版社1990年版，第282页）。   